      SUBROUTINE DEZFTF(N,R,AZERO,A,B,WSAVE) 
C***BEGIN PROLOGUE  DEZFTF    
C***DATE WRITTEN   790601   (YYMMDD)    
C***REVISION DATE  860115   (YYMMDD)    
C***CATEGORY NO.  J1A1   
C***KEYWORDS  FOURIER TRANSFORM    
C***AUTHOR  SWARZTRAUBER, P. N., (NCAR) 
C***PURPOSE  A simplified d. p., periodic, forward transform 
C***DESCRIPTION
C           From the book, "Numerical Methods and Software" by
C                D. Kahaner, C. Moler, S. Nash
C                Prentice Hall, 1988
C    
C  Subroutine DEZFTF computes the Fourier coefficients of a d. p. 
C  perodic sequence (Fourier analysis).  The transform is defined
C  below at Output Parameters AZERO, A and B.  DEZFTF is a simplified 
C  but slower version of DRFFTF.    
C    
C  Input Parameters 
C    
C  N       the length of the array R to be transformed.  The method   
C          is must efficient when N is the product of small primes.   
C    
C  R       a d. p. array of length N which contains the sequence  
C          to be transformed.  R is not destroyed.     
C    
C    
C  WSAVE   a work array which must be dimensioned at least 3*N+15
C          in the program that calls DEZFTF.  The WSAVE array must be 
C          initialized by calling subroutine DEZFTI(N,WSAVE), and a   
C          different WSAVE array must be used for each different 
C          value of N.  This initialization does not have to be  
C          repeated so long as N remains unchanged.  Thus subsequent  
C          transforms can be obtained faster than the first.
C          The same WSAVE array can be used by DEZFTF and EZFFTB.
C    
C  Output Parameters
C    
C  AZERO   the sum from I=1 to I=N of R(I)/N 
C    
C  A,B     for N even B(N/2)=0.0D0 and A(N/2) is the sum from I=1 to     
C          I=N of (-1)**(I-1)*R(I)/N    
C    
C          for N even define KMAX=N/2-1 
C          for N odd  define KMAX=(N-1)/2    
C    
C          then for  k=1,...,KMAX  
C    
C               A(K) equals the sum from I=1 to I=N of 
C    
C                    2.0D0/N*R(I)*COS(K*(I-1)*2*PI/N)
C    
C               B(K) equals the sum from I=1 to I=N of 
C    
C                    2.0D0/N*R(I)*SIN(K*(I-1)*2*PI/N)
C    
C  *                                                                   *   
C  *   References                                                      *   
C  *                                                                   *   
C  *   1. P.N. Swarztrauber, Vectorizing the FFTs, in Parallel         *   
C  *      Computations (G. Rodrigue, ed.), Academic Press, 1982,       *   
C  *      pp. 51-83.                                                   *   
C  *   2. B.L. Buzbee, The SLATEC Common Math Library, in Sources      *   
C  *      and Development of Mathematical Software (W. Cowell, ed.),   *   
C  *      Prentice-Hall, 1984, pp. 302-318.                            *   
C  *                                                                   *   
C    
C***REFERENCES  (NONE)   
C***ROUTINES CALLED  DRFFTF    
C***END PROLOGUE  DEZFTF 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION       R(*)       ,A(*)       ,B(*)       ,WSAVE(*)    
C***FIRST EXECUTABLE STATEMENT  DEZFTF  
      IF (N-2) 101,102,103    
  101 AZERO = R(1)  
      RETURN   
  102 AZERO = 0.5D0*(R(1)+R(2))  
      A(1) = 0.5D0*(R(1)-R(2))   
      RETURN   
  103 DO 104 I=1,N  
         WSAVE(I) = R(I) 
  104 CONTINUE 
      CALL DRFFTF (N,WSAVE,WSAVE(N+1))   
      CF = 2.0D0/DBLE(N)    
      CFM = -CF
      AZERO = 0.5D0*CF*WSAVE(1)  
      NS2 = (N+1)/2 
      NS2M = NS2-1  
      DO 105 I=1,NS2M    
         A(I) = CF*WSAVE(2*I) 
         B(I) = CFM*WSAVE(2*I+1)   
  105 CONTINUE 
      IF (MOD(N,2) .EQ. 0) THEN
          A(NS2) = 0.5D0*CF*WSAVE(N)
          B(NS2) = 0.0D0
      ENDIF
      RETURN   
      END 
